using System;
using System.Data;
using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.ExceptionManagement;
using System.Reflection;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.BOL
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/12/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///MSBOS Component Class business layer class
		///</summary>

		#endregion


	public class MsbosComponentClass : BaseBusinessObject, IRecordStatusCode
	{
		private System.Guid _msbosComponentClassGuid;

		/// <summary>
		/// Unique identifier of msbos parent
		/// </summary>
		private System.Guid _msbosGuid;
		/// <summary>
		/// Unique identifying int of component class
		/// </summary>
		private int _componentClassID;
		private string _componentClassName;
		/// <summary>
		/// Maximum number of units of this type
		/// </summary>
		private short _maximumSetupUnitQuantity;
		/// <summary>
		/// Code to indicate if MSBOS component class is active
		/// </summary>
		private Common.RecordStatusCode _recordStatusCode;



		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="905"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>MSBOS component class constructor</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="379"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// MsbosComponentClass class contsructor
		/// </summary>
		public MsbosComponentClass()
		{
			this._componentClassID = -1;
			this._componentClassName = String.Empty;
			this._maximumSetupUnitQuantity = (short)0;
			this._msbosGuid = System.Guid.Empty;
			this._msbosComponentClassGuid = System.Guid.NewGuid();
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>2/26/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2412"> 
		///		<ExpectedInput>DataRow containing MsbosComponentClass data</ExpectedInput>
		///		<ExpectedOutput>MsbosComponentClass object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2443"> 
		///		<ExpectedInput>Invalid DataRow</ExpectedInput>
		///		<ExpectedOutput>Invalid MsbosComponentClass object</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Creates MsbosComponentClass object and populates it with data from DataRow
		/// </summary>
		/// <param name="dr"></param>
		public MsbosComponentClass(DataRow dr)
		{
			this.LoadFromDataRow(dr);
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4105"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///		
		///<Case type="1" testid ="4106"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets unique identifier of the msbos componentclass
		/// </summary>
		public System.Guid MsbosComponentClassGuid
		{
			get
			{
				return this._msbosComponentClassGuid;
			}
			set
			{
				this._msbosComponentClassGuid = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="906"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="907"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets unique identifier of parent surgery procedure of component class
		/// </summary>
		public System.Guid MsbosGuid
		{
			get
			{
				return _msbosGuid;
			}
			set
			{
				this._msbosGuid = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="908"> 
		///		<ExpectedInput>MsbosComponentClass object</ExpectedInput>
		///		<ExpectedOutput>MSBOS component class ID</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="909"> 
		///		<ExpectedInput>Valid MSBOS component class ID</ExpectedInput>
		///		<ExpectedOutput>Updated MsbosComponentClass object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="910"> 
		///		<ExpectedInput>Invalid MSBOS component class ID (length greater than 25)</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets unique identifying string of component class
		/// </summary>
		public int ComponentClassId
		{
			get
			{
				return _componentClassID;
			}
			set
			{
				this._componentClassID = value;
				
				if (value < 0)
				{
					base.RuleBroken(MethodBase.GetCurrentMethod().Name, true);
					string errorMessage = Common.StrRes.SysErrMsg.Common.RequiredFieldMissing(Common.Utility.ParseStringwithSpaces(MethodBase.GetCurrentMethod().Name, true)).ResString;
					throw new BusinessObjectException(errorMessage);
				}

				RuleBroken(MethodBase.GetCurrentMethod().Name, false);
				this.IsDirty = true;
			}
		}
		
		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/18/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6336"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6337"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// ComponentClassName
		/// </summary>
		public string ComponentClassName
		{
			get
			{
				return this._componentClassName;
			}
			set
			{
				this._componentClassName = value;
			}

		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="911"> 
		///		<ExpectedInput>MsbosComponentClass object</ExpectedInput>
		///		<ExpectedOutput>Unit quantity of MsbosComponentClass object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="912"> 
		///		<ExpectedInput>Valid unit quantity</ExpectedInput>
		///		<ExpectedOutput>Updated MsbosComponentClass object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="913"> 
		///		<ExpectedInput>Invalid unit quantity (less than zero)</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets maximum number of units of component that may be surgically ordered
		/// </summary>
		public short MaximumSetupUnitQuantity
		{
			get
			{
				return _maximumSetupUnitQuantity;
			}
			set
			{
				this._maximumSetupUnitQuantity = value;

				if ((value < 1)||(value > 99))
				{
					base.RuleBroken(MethodBase.GetCurrentMethod().Name, true);
					throw new BusinessObjectException(Common.StrRes.SysErrMsg.Common.RangeError("Value",1,99).ResString);
				}

				RuleBroken(MethodBase.GetCurrentMethod().Name, false);
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/18/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6338"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6339"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets value indicating active status of MSBOS Component Class
		/// </summary>
		public Common.RecordStatusCode RecordStatusCode
		{
			get
			{
				return this._recordStatusCode;
			}
			set
			{
				this._recordStatusCode = value;
				this.IsDirty = true;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Method to load MSBOS component class properties from a given data row
		/// </summary>
		/// <param name="dtRow">Data row containing MSBOS component class information</param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			//Since empty constructors are "bad", and the Clear method is "bad", this is my solution
			if (dtRow.Table.Columns.Contains(Common.VbecsTables.MsbosComponentClass.MsbosComponentClassGuid))
			{
				this._msbosComponentClassGuid = (System.Guid)dtRow[Common.VbecsTables.MsbosComponentClass.MsbosComponentClassGuid];
				this.IsNew = false;
			}
			else
			{
				this._msbosComponentClassGuid = System.Guid.NewGuid();
			}

			//Since empty constructors are "bad", and the Clear method is "bad", this is my solution
			if (dtRow.Table.Columns.Contains(Common.VbecsTables.MsbosComponentClass.ComponentClassId))
			{
				this._componentClassID  = Convert.ToInt32(dtRow[Common.VbecsTables.MsbosComponentClass.ComponentClassId]);
			}
			else
			{
				this._componentClassID = -1;
			}
            
			if (dtRow.Table.Columns.Contains(Common.VbecsTables.MsbosComponentClass.MaximumSetupUnitQuantity))
			{
				this._maximumSetupUnitQuantity = Convert.ToInt16(dtRow[Common.VbecsTables.MsbosComponentClass.MaximumSetupUnitQuantity]);
			}
			else
			{
				this._maximumSetupUnitQuantity  = Convert.ToInt16(0);
			}

			if (dtRow.Table.Columns.Contains(Common.VbecsTables.ComponentClass.ComponentClassName))
			{
				this._componentClassName = dtRow[Common.VbecsTables.ComponentClass.ComponentClassName].ToString();
			}
			else
			{
				this._componentClassName  = String.Empty;
			}

			if (dtRow.Table.Columns.Contains(Common.VbecsTables.MsbosComponentClass.RecordStatusCode))
			{
				this._recordStatusCode = Common.Utility.GetRecordStatusCodeFromString(dtRow[Common.VbecsTables.MsbosComponentClass.RecordStatusCode].ToString());
			}
			else
			{
				this._recordStatusCode = Common.RecordStatusCode.Unknown;
			}

			this._msbosGuid = dtRow.IsNull(Common.VbecsTables.MsbosComponentClass.MsbosGuid) ? Guid.Empty : new Guid(dtRow[Common.VbecsTables.MsbosComponentClass.MsbosGuid].ToString());
		
			if (!dtRow.IsNull(Common.VbecsTables.MsbosComponentClass.RowVersion))
			{
				this.RowVersion = (byte[])dtRow[Common.VbecsTables.MsbosComponentClass.RowVersion];
			}
			this.IsDirty = false;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1225"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="380"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update>Unused</Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			return dtRow;
		}



		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/19/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="915"> 
		///		<ExpectedInput>MsbosComponentClass object</ExpectedInput>
		///		<ExpectedOutput>Updated MsbosComponentClass object with properties reset</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="384"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Public method to reset MSBOS component class properties to initial values
		/// </summary>
		public void Clear()
		{
			this._componentClassID = -1;
			this._msbosGuid = Guid.Empty;
			this._msbosComponentClassGuid = Guid.NewGuid();
			this._maximumSetupUnitQuantity = 1;
			this._recordStatusCode = Common.RecordStatusCode.Inactive;
			this.IsDirty = false;
			this.IsNew = true;
		}

	}
}
